% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obfuscatePed.R
\name{obfuscatePed}
\alias{obfuscatePed}
\title{obfuscatePed takes a pedigree object and creates aliases for all IDs and
adjusts all date within a specified amount.}
\usage{
obfuscatePed(
  ped,
  size = 6L,
  maxDelta = 30L,
  existingIds = character(0L),
  map = FALSE
)
}
\arguments{
\item{ped}{pedigree object}

\item{size}{integer value indicating number of characters in alias IDs}

\item{maxDelta}{integer value indicating maximum number of days that
the birthdate can be shifted}

\item{existingIds}{character vector of existing aliases to avoid duplication.}

\item{map}{logical if \code{TRUE} a list object is returned with the new
pedigree and a named character vector with the names being the original IDs
and the values being the new alias values. Defaults to \code{FALSE}.}
}
\value{
An obfuscated pedigree
}
\description{
User provides a pedigree object (\code{ped}), the number of characters to be
used for alias IDs (\code{size}), and the maximum number of days that the
birthdate can be shifted (\code{maxDelta}).
}
\examples{
library(nprcgenekeepr)
ped <- qcStudbook(nprcgenekeepr::pedGood)
obfuscatedPed <- obfuscatePed(ped)
ped
obfuscatedPed
}
