% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_player_stats.R
\name{fetch_player_stats}
\alias{fetch_player_stats}
\title{Fetch Player Stats from Multiple Rugby League Sources}
\usage{
fetch_player_stats(
  season = NULL,
  league = c("nrl", "super_league", "championship", "league_one", "womens_super_league",
    "qld_cup", "nsw_cup"),
  round = NULL,
  comp = NULL,
  source = c("championdata", "rugbyproject")
)
}
\arguments{
\item{season}{Integer scalar. Season year (rugbyproject only).}

\item{league}{Character scalar. League name (rugbyproject only).}

\item{round}{Integer scalar or NULL. Round number filter (both sources).}

\item{comp}{Integer. Competition ID (championdata only).}

\item{source}{Character scalar. One of "championdata" or "rugbyproject". Default is "championdata".}
}
\value{
A tibble of player stats joined with fixture info.
}
\description{
Unified wrapper to fetch player stats from either Champion Data MC API (NRL/NRLW/State of Origin)
or Rugby League Project web scraping.
}
\details{
For `source = "championdata"`, provide `comp` (competition ID). `round` is optional.
For `source = "rugbyproject"`, provide `season`, `league`, and optionally `round`.
}
