% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhav.R
\name{bhav}
\alias{bhav}
\title{Bhavcopy from NSE}
\source{
<https://www1.nseindia.com/products/content/all_daily_reports.htm>, <https://www.bseindia.com/markets/marketinfo/BhavCopy.aspx>
}
\usage{
bhav(x, se = "NSE")
}
\arguments{
\item{x}{numeric date format}

\item{se}{Stock Exchange either 'NSE' or 'BSE'. Default is 'NSE'.}
}
\value{
Bhavcopy for the given date.
}
\description{
Bhavcopy from NSE
}
\details{
Gets Bhavcopy from NSE for the given date. The function tries to get the bhavcopy from two sources i.e., Old and New website of NSE.
}
\note{
The date should be strictly numerical and mentioned in quotation mark. `bhav` can be used to download bhavcopy from 1 Jan 2016 on wards. To download bhavcopy previous to aforementioned date use `bhavs`.
}
\examples{
\donttest{
#Download Bhavcopy from NSE
report = bhav("01072021") # Download bhavcopy for 01 July 2021

#Download bhavcopy from BSE
report = bhav("01072021", 'BSE')
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhavtoday}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
