% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nselive.R
\name{nselive}
\alias{nselive}
\title{NSE Live Market data}
\source{
<https://www.nseindia.com/market-data/live-market-indices>
}
\usage{
nselive(x = "n50")
}
\arguments{
\item{x}{"n50" and "fo" for nifty 50 and F&O. DEFAULT value is "n50".}
}
\value{
A dataframe with NSE Live market data.
}
\description{
NSE Live Market data
}
\details{
Get live NSE market data of Nifty 50 and Futures & Options
}
\note{
NSE pre-open market 09.00 hrs to 9.08 hrs (IST). Regular Trading Session 09.15 hrs to 15.30 hrs (IST)
}
\examples{
\dontrun{
# NSE Live market data for Nifty 50 stocks
library(nser)
nselive()

# Live market for F&O stocks
nselive("fo")
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhav}}\code{\link[nser]{fobhavtoday}}\code{\link[nser]{nseindex}}\code{\link[nser]{nseopen}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
