% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_generation.R
\name{correlated_brownian_noise}
\alias{correlated_brownian_noise}
\title{Generates multidimensional correlated Brownian motion increments}
\usage{
correlated_brownian_noise(n, sigma_matrix, delta_time)
}
\arguments{
\item{n}{Sample length}

\item{sigma_matrix}{Correlation/Covariance matrix}

\item{delta_time}{Time difference between steps}
}
\value{
A matrix with \code{n} rows of correlated Brownian motion using the
correlation matrix \code{sigma_matrix} using time step \code{delta_time}.
}
\description{
Generates multidimensional correlated Brownian motion increments
}
\examples{
set.seed(42)
corr_mat <- matrix(c(1.0, 0.2, 0.2, 0.2, 1.0, 0.2, 0.2, 0.2, 1.0), 3, 3)
n <- 1000
delta_time <- 0.01
correlated_brownian_noise(
  sigma_matrix = corr_mat, n = n, delta_time = delta_time
)
}
