% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_model_10.R
\name{imTen}
\alias{imTen}
\title{Item Model 10}
\usage{
imTen(items, logic = "one", n = 2, arith = "add")
}
\arguments{
\item{items}{Generate a random mix of items.}

\item{logic}{The combination of sequences follow two logic ("one" or "two").}

\item{n}{The value that the arithmetic operator uses to calculate the next value}

\item{arith}{The arithmetic operator of your choice ("add","substr","multi","div").}
}
\description{
This uses item model 10 to create number series items - Combined identification of parallel sub-sequences and progressively evolving coefficients of change.
}
\details{
The number series items are a combination of Arithmetic, linear sequence and progressive coefficient. \cr
First logic is combining sequences x y x y x y x y = one simple (cannot be controlled), one progressive . \cr
Second logic is combining sequences x y x y x y x y = two progressive. The minimum number of items that will be generated is 2. \cr
Logic analogous to the Item Model 5, but at least one sub-sequence involves a progressively evolving coefficient. Sub-sequences involve items from Item Families 1, 3, and 7. Example: The coefficient of change between odd elements in the sequence increases by 1. The coefficient of change between even elements increases by -1. (2 8 4 7 7 5 11 2 16 (-2) (22)).

When using the first logic, n corresponds to the change in the progressive pattern. However, the simple pattern is fixed and hence drawn randomly.
}
\examples{

#Draws 10 items randomly.
imTen(10,logic="one", n=2,arith="add")


}
\author{
Aiden Loe and Filip Simonfy
}
