% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_group_hmms}
\alias{run_group_hmms}
\title{Run multiple HMMs}
\usage{
run_group_hmms(
  bulks,
  t = 1e-04,
  gamma = 20,
  alpha = 1e-04,
  min_genes = 10,
  nu = 1,
  common_diploid = TRUE,
  diploid_chroms = NULL,
  allele_only = FALSE,
  retest = TRUE,
  run_hmm = TRUE,
  exclude_neu = TRUE,
  ncores = 1,
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{bulks}{dataframe Pseudobulk profiles}

\item{t}{numeric Transition probability}

\item{gamma}{numeric Dispersion parameter for the Beta-Binomial allele model}

\item{alpha}{numeric P value cut-off to determine segment clusters in find_diploid}

\item{common_diploid}{logical Whether to find common diploid regions between pseudobulks}

\item{diploid_chroms}{character vector Known diploid chromosomes to use as baseline}

\item{allele_only}{logical Whether only use allele data to run HMM}

\item{retest}{logcial Whether to retest CNVs}

\item{run_hmm}{logical Whether to run HMM segments or just retest}

\item{ncores}{integer Number of cores}
}
\description{
Run multiple HMMs
}
\keyword{internal}
