% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_nutrientsource}
\alias{get_nutrientsource}
\title{get_nutrientsource}
\usage{
get_nutrientsource(apiKey = NULL, nutrientSourceId = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{nutrientSourceId}{The code indicating the nutrient source you want to search for. If null,
all nutrient sources are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing the id's of nutrient sources as well as their corresponding description.
}
\description{
Makes a query to the Canadian Nutrient File nutrientsource endpoint. This endpoint returns
a list of nutrient source id's and their corresponding description.
}
\examples{
\dontrun{
get_nutrientsource()
get_nutrientsource(nutrientSourceId = 108)
get_nutrientsource(nutrientSourceId = 108, lang = "fr")}
}
