% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.getMedia}
\alias{labbcat.getMedia}
\title{Gets a given media track for a given graph.}
\usage{
labbcat.getMedia(labbcat, id, trackSuffix = "", mimeType = "audio/wav")
}
\arguments{
\item{labbcat}{A LaBB-CAT instance object previously created by a call to labbcat.instance}

\item{id}{A graph ID (i.e. transcript name)}

\item{trackSuffix}{The track suffix of the media}

\item{mimeType}{The MIME type of the media}
}
\value{
A URL to the given media for the given graph
}
\description{
Gets a given media track for a given graph.
}
\examples{
## Connect to LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/", "demo", "demo")

## Get URL for the WAV file for BR2044_OllyOhlson.eaf
media <- labbcat.getMedia(labbcat, "BR2044_OllyOhlson.eaf")

## Get URL for the 'QuakeFace' video file for BR2044_OllyOhlson.eaf
media <- labbcat.getMedia(labbcat, "BR2044_OllyOhlson.eaf", "_face", "video/mp4")

}
\seealso{
\link{labbcat.getGraphIds}
}
\keyword{audio}
\keyword{media}
