test_that("praatScriptFastTrack default arguments works", {    
    script <- paste(
        "\ninclude utils/trackAutoselectProcedure.praat",
        "\n@getSettings",
        "\ntime_step = 0.002",
        "\nmethod$ = \"burg\"",
        "\nenable_F1_frequency_heuristic = 1",
        "\nmaximum_F1_frequency_value = 1200",
        "\nenable_F1_bandwidth_heuristic = 0",
        "\nenable_F2_bandwidth_heuristic = 0",
        "\nenable_F3_bandwidth_heuristic = 0",
        "\nenable_F4_frequency_heuristic = 1",
        "\nminimum_F4_frequency_value = 2900",
        "\nenable_rhotic_heuristic = 1",
        "\nenable_F3F4_proximity_heuristic = 1",
        "\noutput_bandwidth = 1",
        "\noutput_predictions = 1",
        "\noutput_pitch = 1",
        "\noutput_intensity = 1",
        "\noutput_harmonicity = 1",
        "\noutput_normalized_time = 1",
        "\ndir$ = \".\"",
        "\nsteps = 20",
        "\ncoefficients = 5",
        "\nformants = 3",
        "\nout_formant = 2",
        "\nimage = 0",
        "\nmax_plot = 4000",
        "\nout_table = 0",
        "\nout_all = 0",
        "\ncurrent_view = 0",
        "\nfastTrackMinimumDuration = 0.030000000000001",
        "\nlowestAnalysisFrequency = 5000",
        "\nhighestAnalysisFrequency = 7000",
        "\nif participant_gender$ = \"M\"",
        "\n  lowestAnalysisFrequency = 4500",
        "\n  highestAnalysisFrequency = 6500",
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\nif windowDuration >= fastTrackMinimumDuration",
        "\n  @trackAutoselect: selected(), dir$, lowestAnalysisFrequency, highestAnalysisFrequency, steps, coefficients, formants, method$, image, selected(), current_view, max_plot, out_formant, out_table, out_all",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  pointoffset = targetStart + 0.5 * targetDuration",
        "\n  f1_time_0_5 = Get value at time: 1, pointoffset, \"hertz\", \"Linear\"",
        "\n  f2_time_0_5 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  Remove",
        "\nelse",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  f1_time_0_5 = \"\"",
        "\n  f2_time_0_5 = \"\"",
        "\nendif",
        "\n",
        "\nprint 'time_0_5' 'newline$'",
        "\nprint 'f1_time_0_5' 'newline$'",
        "\nprint 'f2_time_0_5' 'newline$'",
        "\n",
        sep="")
    expect_equal(praatScriptFastTrack(), script)
})

test_that("praatScriptFastTrack with more formants works", {    
    script <- paste(
        "\ninclude utils/trackAutoselectProcedure.praat",
        "\n@getSettings",
        "\ntime_step = 0.002",
        "\nmethod$ = \"burg\"",
        "\nenable_F1_frequency_heuristic = 1",
        "\nmaximum_F1_frequency_value = 1200",
        "\nenable_F1_bandwidth_heuristic = 0",
        "\nenable_F2_bandwidth_heuristic = 0",
        "\nenable_F3_bandwidth_heuristic = 0",
        "\nenable_F4_frequency_heuristic = 1",
        "\nminimum_F4_frequency_value = 2900",
        "\nenable_rhotic_heuristic = 1",
        "\nenable_F3F4_proximity_heuristic = 1",
        "\noutput_bandwidth = 1",
        "\noutput_predictions = 1",
        "\noutput_pitch = 1",
        "\noutput_intensity = 1",
        "\noutput_harmonicity = 1",
        "\noutput_normalized_time = 1",
        "\ndir$ = \".\"",
        "\nsteps = 20",
        "\ncoefficients = 5",
        "\nformants = 4",
        "\nout_formant = 2",
        "\nimage = 0",
        "\nmax_plot = 4000",
        "\nout_table = 0",
        "\nout_all = 0",
        "\ncurrent_view = 0",
        "\nfastTrackMinimumDuration = 0.030000000000001",
        "\nlowestAnalysisFrequency = 5000",
        "\nhighestAnalysisFrequency = 7000",
        "\nif participant_gender$ = \"M\"",
        "\n  lowestAnalysisFrequency = 4500",
        "\n  highestAnalysisFrequency = 6500",
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\nif windowDuration >= fastTrackMinimumDuration",
        "\n  @trackAutoselect: selected(), dir$, lowestAnalysisFrequency, highestAnalysisFrequency, steps, coefficients, formants, method$, image, selected(), current_view, max_plot, out_formant, out_table, out_all",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  pointoffset = targetStart + 0.5 * targetDuration",
        "\n  f2_time_0_5 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  f3_time_0_5 = Get value at time: 3, pointoffset, \"hertz\", \"Linear\"",
        "\n  f4_time_0_5 = Get value at time: 4, pointoffset, \"hertz\", \"Linear\"",
        "\n  Remove",
        "\nelse",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  f2_time_0_5 = \"\"",
        "\n  f3_time_0_5 = \"\"",
        "\n  f4_time_0_5 = \"\"",
        "\nendif",
        "\n",
        "\nprint 'time_0_5' 'newline$'",
        "\nprint 'f2_time_0_5' 'newline$'",
        "\nprint 'f3_time_0_5' 'newline$'",
        "\nprint 'f4_time_0_5' 'newline$'",
        "\n",
        sep="")
    expect_equal(praatScriptFastTrack(formants = c(2,3,4), number.of.formants = 4), script)
})

test_that("praatScriptFastTrack with more points works", {    
    script <- paste(
        "\ninclude utils/trackAutoselectProcedure.praat",
        "\n@getSettings",
        "\ntime_step = 0.002",
        "\nmethod$ = \"burg\"",
        "\nenable_F1_frequency_heuristic = 1",
        "\nmaximum_F1_frequency_value = 1200",
        "\nenable_F1_bandwidth_heuristic = 0",
        "\nenable_F2_bandwidth_heuristic = 0",
        "\nenable_F3_bandwidth_heuristic = 0",
        "\nenable_F4_frequency_heuristic = 1",
        "\nminimum_F4_frequency_value = 2900",
        "\nenable_rhotic_heuristic = 1",
        "\nenable_F3F4_proximity_heuristic = 1",
        "\noutput_bandwidth = 1",
        "\noutput_predictions = 1",
        "\noutput_pitch = 1",
        "\noutput_intensity = 1",
        "\noutput_harmonicity = 1",
        "\noutput_normalized_time = 1",
        "\ndir$ = \".\"",
        "\nsteps = 20",
        "\ncoefficients = 5",
        "\nformants = 3",
        "\nout_formant = 2",
        "\nimage = 0",
        "\nmax_plot = 4000",
        "\nout_table = 0",
        "\nout_all = 0",
        "\ncurrent_view = 0",
        "\nfastTrackMinimumDuration = 0.030000000000001",
        "\nlowestAnalysisFrequency = 5000",
        "\nhighestAnalysisFrequency = 7000",
        "\nif participant_gender$ = \"M\"",
        "\n  lowestAnalysisFrequency = 4500",
        "\n  highestAnalysisFrequency = 6500",
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\nif windowDuration >= fastTrackMinimumDuration",
        "\n  @trackAutoselect: selected(), dir$, lowestAnalysisFrequency, highestAnalysisFrequency, steps, coefficients, formants, method$, image, selected(), current_view, max_plot, out_formant, out_table, out_all",
        "\n  pointoffset = targetAbsoluteStart + 0.25 * targetDuration",
        "\n  time_0_25 = pointoffset",
        "\n  pointoffset = targetStart + 0.25 * targetDuration",
        "\n  f1_time_0_25 = Get value at time: 1, pointoffset, \"hertz\", \"Linear\"",
        "\n  f2_time_0_25 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  pointoffset = targetStart + 0.5 * targetDuration",
        "\n  f1_time_0_5 = Get value at time: 1, pointoffset, \"hertz\", \"Linear\"",
        "\n  f2_time_0_5 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  pointoffset = targetAbsoluteStart + 0.75 * targetDuration",
        "\n  time_0_75 = pointoffset",
        "\n  pointoffset = targetStart + 0.75 * targetDuration",
        "\n  f1_time_0_75 = Get value at time: 1, pointoffset, \"hertz\", \"Linear\"",
        "\n  f2_time_0_75 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  Remove",
        "\nelse",
        "\n  pointoffset = targetAbsoluteStart + 0.25 * targetDuration",
        "\n  time_0_25 = pointoffset",
        "\n  f1_time_0_25 = \"\"",
        "\n  f2_time_0_25 = \"\"",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  f1_time_0_5 = \"\"",
        "\n  f2_time_0_5 = \"\"",
        "\n  pointoffset = targetAbsoluteStart + 0.75 * targetDuration",
        "\n  time_0_75 = pointoffset",
        "\n  f1_time_0_75 = \"\"",
        "\n  f2_time_0_75 = \"\"",
        "\nendif",
        "\n",
        "\nprint 'time_0_25' 'newline$'",
        "\nprint 'f1_time_0_25' 'newline$'",
        "\nprint 'f2_time_0_25' 'newline$'",
        "\nprint 'time_0_5' 'newline$'",
        "\nprint 'f1_time_0_5' 'newline$'",
        "\nprint 'f2_time_0_5' 'newline$'",
        "\nprint 'time_0_75' 'newline$'",
        "\nprint 'f1_time_0_75' 'newline$'",
        "\nprint 'f2_time_0_75' 'newline$'",
        "\n",
        sep="")
    expect_equal(praatScriptFastTrack(sample.points = c(0.25, 0.5, 0.75)), script)
})

test_that("praatScriptFastTrack with non-default arguments works", {    
    script <- paste(
        "\ninclude utils/trackAutoselectProcedure.praat",
        "\n@getSettings",
        "\ntime_step = 0.001",
        "\nmethod$ = \"robust\"",
        "\nenable_F1_frequency_heuristic = 0",
        "\nenable_F1_bandwidth_heuristic = 1",
        "\nmaximum_F1_bandwidth_value = 500",
        "\nenable_F2_bandwidth_heuristic = 1",
        "\nmaximum_F2_bandwidth_value = 600",
        "\nenable_F3_bandwidth_heuristic = 1",
        "\nmaximum_F3_bandwidth_value = 900",
        "\nenable_F4_frequency_heuristic = 0",
        "\nenable_rhotic_heuristic = 0",
        "\nenable_F3F4_proximity_heuristic = 0",
        "\noutput_bandwidth = 1",
        "\noutput_predictions = 1",
        "\noutput_pitch = 1",
        "\noutput_intensity = 1",
        "\noutput_harmonicity = 1",
        "\noutput_normalized_time = 1",
        "\ndir$ = \".\"",
        "\nsteps = 40",
        "\ncoefficients = 7",
        "\nformants = 3",
        "\nout_formant = 2",
        "\nimage = 0",
        "\nmax_plot = 4000",
        "\nout_table = 0",
        "\nout_all = 0",
        "\ncurrent_view = 0",
        "\nfastTrackMinimumDuration = 0.030000000000001",
        "\nlowestAnalysisFrequency = 4500",
        "\nhighestAnalysisFrequency = 7500",
        "\nselect Sound 'sampleName$'",
        "\nif windowDuration >= fastTrackMinimumDuration",
        "\n  @trackAutoselect: selected(), dir$, lowestAnalysisFrequency, highestAnalysisFrequency, steps, coefficients, formants, method$, image, selected(), current_view, max_plot, out_formant, out_table, out_all",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  pointoffset = targetStart + 0.5 * targetDuration",
        "\n  f1_time_0_5 = Get value at time: 1, pointoffset, \"hertz\", \"Linear\"",
        "\n  f2_time_0_5 = Get value at time: 2, pointoffset, \"hertz\", \"Linear\"",
        "\n  Remove",
        "\nelse",
        "\n  pointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\n  time_0_5 = pointoffset",
        "\n  f1_time_0_5 = \"\"",
        "\n  f2_time_0_5 = \"\"",
        "\nendif",
        "\n",
        "\nprint 'time_0_5' 'newline$'",
        "\nprint 'f1_time_0_5' 'newline$'",
        "\nprint 'f2_time_0_5' 'newline$'",
        "\n",
        sep="")
    expect_equal(praatScriptFastTrack(lowest.analysis.frequency = 4500, lowest.analysis.frequency.male = NULL, highest.analysis.frequency = 7500, highest.analysis.frequency.male = NULL, gender.attribute = NULL, value.for.male = NULL, time.step = 0.001, tracking.method = "robust", maximum.f1.frequency = NULL, maximum.f1.bandwidth = 500, maximum.f2.bandwidth = 600, maximum.f3.bandwidth = 900, minimum.f4.frequency = NULL, enable.rhotic.heuristic = FALSE, enable.f3.f4.proximity.heuristic = FALSE, number.of.steps = 40, number.of.coefficients = 7), script)
})

