test_that("praatScriptPitch default arguments works", {    
    script <- paste(
        "\npitchfloor = 60",
        "\nvoicingthreshold = 0.5",
        "\npitchceiling = 500",
        "\nveryaccurate$ = \"no\"",
        "\nif participant_gender$ = \"M\"",
        "\n  pitchfloor = 30",
        "\nendif",
        "\nif participant_gender$ = \"M\"",
        "\n  voicingthreshold = 0.4",
        "\nendif",
        "\nif participant_gender$ = \"M\"",
        "\n  pitchceiling = 250",
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\n# nocheck to prevent the whole script from failing, and then check for object after",
        "\nnocheck ",
        "To Pitch (ac): 0, pitchfloor, 15, veryaccurate$, 0.03, voicingthreshold, 0.01, 0.35, ",
        "0.35, pitchceiling",
        "\n# check that a Pitch object was created",
        "\nobjectCreated = extractWord$(selected$(), \"\") = \"Pitch\"",
        "\nif objectCreated",
        "\n  meanPitch = Get mean: targetStart, targetEnd, \"Hertz\"",
        "\nelse",
        "\n  meanPitch = 1/0",
        "\nendif",
        "\nprint 'meanPitch' 'newline$'",
        "\nif objectCreated",
        "\n  Remove",
        "\nendif\n",
        sep="")
    expect_equal(praatScriptPitch(), script)
})

test_that("praatScriptPitch works with sample.points", {    
    script <- paste(
        "\npitchfloor = 60",
        "\nvoicingthreshold = 0.5",
        "\npitchceiling = 500",
        "\nveryaccurate$ = \"no\"",
        "\nif participant_gender$ = \"M\"",
        "\n  pitchfloor = 30",
        "\nendif",
        "\nif participant_gender$ = \"M\"",
        "\n  voicingthreshold = 0.4",
        "\nendif",
        "\nif participant_gender$ = \"M\"",
        "\n  pitchceiling = 250",
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\n# nocheck to prevent the whole script from failing, and then check for object after",
        "\nnocheck ",
        "To Pitch (ac): 0, pitchfloor, 15, veryaccurate$, 0.03, voicingthreshold, 0.01, 0.35, ",
        "0.35, pitchceiling",
        "\n# check that a Pitch object was created",
        "\nobjectCreated = extractWord$(selected$(), \"\") = \"Pitch\"",
        "\npointoffset = targetAbsoluteStart + 0.3 * targetDuration",
        "\ntime_0_3_for_pitch = pointoffset",
        "\nprint 'time_0_3_for_pitch' 'newline$'",
        "\npointoffset = targetStart + 0.3 * targetDuration",
        "\nif objectCreated",
        "\n  pitch_time_0_3 = Get value at time: pointoffset, \"Hertz\", \"linear\"",
        "\nelse",
        "\n  pitch_time_0_3 = 1/0",
        "\nendif",
        "\nprint 'pitch_time_0_3:0' 'newline$'",
        "\npointoffset = targetAbsoluteStart + 0.6 * targetDuration",
        "\ntime_0_6_for_pitch = pointoffset",
        "\nprint 'time_0_6_for_pitch' 'newline$'",
        "\npointoffset = targetStart + 0.6 * targetDuration",
        "\nif objectCreated",
        "\n  pitch_time_0_6 = Get value at time: pointoffset, \"Hertz\", \"linear\"",
        "\nelse",
        "\n  pitch_time_0_6 = 1/0",
        "\nendif",
        "\nprint 'pitch_time_0_6:0' 'newline$'",
        "\nif objectCreated",
        "\n  Remove",
        "\nendif\n",
        sep="")
    expect_equal(praatScriptPitch(sample.points = c(0.3,0.6), get.mean = FALSE), script)
})

test_that("praatScriptIntensity with non-default arguments works", {    
    script <- paste(
        "\npitchfloor = 50",
        "\nvoicingthreshold = 0.55",
        "\npitchceiling = 600",
        "\nveryaccurate$ = \"yes\"",
        "\nif participant_sex$ = \"male\"",
        "\n  pitchfloor = 40",
        "\nendif",
        "\nif participant_sex$ = \"male\"",
        "\n  pitchceiling = 300", 
        "\nendif",
        "\nselect Sound 'sampleName$'",
        "\nTo Pitch (ac): 0.01, pitchfloor, 10, veryaccurate$, 0.035, voicingthreshold, 0.02, ",
        "0.4, 0.45, pitchceiling",
        "\n# check that a Pitch object was created",
        "\nobjectCreated = extractWord$(selected$(), \"\") = \"Pitch\"",
        "\nif objectCreated",
        "\n  minPitch = Get minimum: targetStart, targetEnd, \"Hertz\", \"Parabolic\"",
        "\nelse",
        "\n  minPitch = 1/0",
        "\nendif",
        "\nprint 'minPitch' 'newline$'",
        "\nif objectCreated",
        "\n  maxPitch = Get maximum: targetStart, targetEnd, \"Hertz\", \"Parabolic\"",
        "\nelse",
        "\n  maxPitch = 1/0",
        "\nendif",
        "\nprint 'maxPitch' 'newline$'",
        "\npointoffset = targetAbsoluteStart + 0.5 * targetDuration",
        "\ntime_0_5_for_pitch = pointoffset",
        "\nprint 'time_0_5_for_pitch' 'newline$'",
        "\npointoffset = targetStart + 0.5 * targetDuration",
        "\nif objectCreated",
        "\n  pitch_time_0_5 = Get value at time: pointoffset, \"Hertz\", \"nearest\"",
        "\nelse",
        "\n  pitch_time_0_5 = 1/0",
        "\nendif",
        "\nprint 'pitch_time_0_5:0' 'newline$'",
        "\nif objectCreated",
        "\n  Remove",
        "\nendif\n",
        sep="")
    expect_equal(praatScriptPitch(
        get.mean = FALSE, get.minimum = TRUE, get.maximum = TRUE,
        time.step = 0.01, pitch.floor = 50, max.number.of.candidates = 10, very.accurate = TRUE,
        silence.threshold = 0.035, voicing.threshold = 0.55, octave.cost = 0.02,
        octave.jump.cost = 0.4, voiced.unvoiced.cost = 0.45,
        pitch.ceiling = 600, pitch.floor.male = 40, voicing.threshold.male = 0.55,
        pitch.ceiling.male = 300, gender.attribute = 'participant_sex', value.for.male = "male",
        sample.points = c(0.5), interpolation = "nearest", skip.errors = FALSE),
        script)
})
