% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_test_plots.R
\name{plot_variance_explained}
\alias{plot_variance_explained}
\title{Create plot of variances explained from \code{pca_test} object}
\usage{
plot_variance_explained(pca_test, pc_max = NA, percent = TRUE)
}
\arguments{
\item{pca_test}{an object of class pca_test_results generated by \code{pca_test}.}

\item{pc_max}{the maximum number of PCs to plot. If NA, plot all PCs.}

\item{percent}{if TRUE, represent variance explained as a percentage. If
FALSE, represent as eigenvalues.}
}
\value{
\code{ggplot} object.
}
\description{
The variance explained by each PC in a dataset is plotted with confidence
intervals generated by bootstrapping and a null distribution generated by
permutation. The function accepts the result of calling the \code{pca_test}
function.
}
\details{
By default, variance explained is represented as a percentage. If the
argument \code{percent} is set to FALSE, then the variance explained is
represented by the eigenvalues corresponding to each PC.
}
\examples{
  onze_pca <- pca_test(onze_intercepts |> dplyr::select(-speaker), n = 10)
  # Plot with percentages
  plot_variance_explained(onze_pca)
  # Plot with eigenvalues and only the first 5 PCs.
  plot_variance_explained(onze_pca, pc_max = 5, percent = FALSE)
}
