% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotVolumePercentiles}
\alias{plotVolumePercentiles}
\title{Visualise available limit order book liquidity through time.}
\usage{
plotVolumePercentiles(depth.summary,
  start.time = head(depth.summary$timestamp, 1),
  end.time = tail(depth.summary$timestamp, 1), volume.scale = 1,
  perc.line = T, side.line = T)
}
\arguments{
\item{depth.summary}{\code{\link{depth.summary}} data.}

\item{start.time}{Plot events from this time onward.}

\item{end.time}{Plot events up until this time.}

\item{volume.scale}{Volume scale factor.}

\item{perc.line}{If true, separate percentiles with subtle line.}

\item{side.line}{If true, separate bid/ask side with subtle line.}
}
\description{
Plots the available volume in 25bps increments on each side of the order
book in the form of a stacked area graph.
}
\details{
The top of the graph depicts the ask side of the book, whilst the bottom
depicts the bid side. Percentiles and order book sides can be separated by an
optional subtle line for improved legibility.
}
\examples{

# visualise 2 hours of order book liquidity.
# data will be aggregated to minute-by-minute resolution.
plotVolumePercentiles(lob.data$depth.summary,
    start.time=as.POSIXct("2015-05-01 02:30:00.000", tz="UTC"),
    end.time=as.POSIXct("2015-05-01 04:30:00.000", tz="UTC"),
    volume.scale=10^-8)

\dontrun{

# visualise 15 minutes of order book liquidity.
# data will be aggregated to second-by-second resolution.
plotVolumePercentiles(lob.data$depth.summary,
    start.time=as.POSIXct("2015-05-01 04:30:00.000", tz="UTC"),
    end.time=as.POSIXct("2015-05-01 04:35:00.000", tz="UTC"),
    volume.scale=10^-8)
}
}
\author{
phil
}

