% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{[[<-,oce-method}
\alias{[[<-,oce-method}
\title{Change Something Within an oce Object}
\usage{
\S4method{[[}{oce}(x, i, j, ...) <- value
}
\arguments{
\item{x}{An oce object.}

\item{i}{The item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}

\item{value}{The value to be inserted into \code{x}.}
}
\description{
This is a base function that can be used to change items
in the \code{metadata} or \code{data} slot of an
object of the \code{\link{oce-class}}. See 
\dQuote{Details} for the case in which both slots
contain an item of the given name.

The first step is to an item of the indicated name. First,
it is sought in the \code{metadata} slot, and if it is found
there, then that value is altered. If it is not found there,
it is sought in the \code{data} slot and modified there.
}
\examples{
data(ctd)
summary(ctd)
# Move the CTD profile a nautical mile north,
ctd[["latitude"]] <- 1/60 + ctd[["latitude"]] # in metadata
# Increase the salinity by 0.01.
ctd[["salinity"]] <- 0.01 + ctd[["salinity"]] # in data
summary(ctd)
}

