% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\docType{methods}
\name{subset,argo-method}
\alias{subset,argo-method}
\alias{subset.argo}
\title{Subset an argo object}
\usage{
\S4method{subset}{argo}(x, subset, ...)
}
\arguments{
\item{x}{An object inheriting from \code{\link{argo-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{...}{Ignored.}
}
\value{
An argo object.
}
\description{
This function is somewhat analogous to
\code{\link{subset.data.frame}}, but only one independent variable may be
used in \code{subset} in any call to the function, which means that
repeated calls will be necessary to subset based on more than one
independent variable.  Subsetting may be by by anything
stored in the data, e.g. \code{time},
\code{latitude}, \code{longitude}, \code{profile}, \code{dataMode},
or \code{pressure} or by \code{profile} (a made-up variable)
or \code{id} (from the \code{metadata} slot).
}
\examples{
library(oce)
data(argo)
par(mfrow=c(2,2))
plot(argo)
plot(subset(argo, time > mean(time)))
plot(subset(argo, longitude > mean(longitude)))
plot(subset(argoGrid(argo), pressure > 500 & pressure < 1000), which=5)

# Plot only delayed-mode profiles.
par(mfrow=c(1,1))
plot(subset(argo, dataMode == "D"))
}
\seealso{
\code{\link{argoGrid}} for gridding argo objects.
}

