% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce-deprecated}
\alias{oce-defunct}
\alias{oce-deprecated}
\title{Deprecated and Defunct Elements of package \sQuote{oce}}
\description{
Certain functions and function arguments are still provided for
compatibility with older versions of \sQuote{oce}, but will be removed soon.
The \sQuote{oce} scheme for removing functions is similar to that used by
\sQuote{Bioconductor}: items are marked as "deprecated" in one release, as
"defunct" in the next, and then removed entirely. This goal is to provide a
gentle migration path for users who keep their packages reasonably
up-to-date.
}
\details{
Several \sQuote{oce} functions are marked "deprecated" in the present
release of oce. Please use the replacement functions as listed below.

\tabular{lll}{
\strong{Deprecated}    \tab \strong{Replacement}     \tab \strong{Notes}\cr
\code{mapZones}        \tab \code{\link{mapGrid}}    \tab Improve name sensibility\cr
\code{mapMeridians}    \tab \code{\link{mapGrid}}    \tab Improve name sensibility\cr
\code{addColumn}       \tab \code{\link{oceSetData}} \tab Deprecated 2016-08-01\cr
\code{oce.magic}       \tab \code{\link{oceMagic}}   \tab Deprecated 2016-09-01\cr
\code{ctdAddColumn}    \tab \code{\link{oceSetData}} \tab Deprecated 2016-11-11\cr
\code{ctdUpdateHeader} \tab -                        \tab Deprecated 2016-11-11\cr
}

The next CRAN release of \sQuote{oce} will have these functions flagged as
"defunct", which will mean that trying to use them will generate an error
and a hint as to the replacement function.

The following are marked "defunct", which means that calling them in the
present version of oce will produce an error, and that they will be removed
altogether in the next oce release on CRAN.

\tabular{lll}{
\strong{Defunct}   \tab \strong{Replacement}     \tab \strong{Notes}\cr
\code{makeSection} \tab \code{\link{as.section}} \tab Improve utility and name sensibility\cr
\code{columns}     \tab \code{\link{read.ctd}}   \tab Unnecessary, and never worked\cr
}

Several \sQuote{oce} function arguments are considered defunct, which
means they will be removed in the next CRAN release. They are as follows.

\itemize{

\item The \code{date} argument of \code{\link{as.ctd}}
was discovered to have been unused in early 2016. Since
the \code{startTime} actually fills its role, \code{date}
was considered to be deprecated in June 2016.

\item The \code{quality} flag of \code{\link{as.ctd}} was
marked as deprecated in March 2016.

\item The \code{fill} argument of \code{\link{mapPlot}} was confusing
to users, so it was designated as deprecated in June 2016.
(The confusion stemmed from subtle differences between
\code{\link{plot}} and \code{\link{polygon}}, and the problem is that
\code{\link{mapPlot}} can use either of these functions, according
to whether coastlines are to be filled.)
The functionality is preserved, in the \code{col} argument.

\item The \code{adorn} argument of \code{\link{plot,ctd-method}} and
other functions was realized in June 2016 to be dangerous. (If the
adornment code contained assignments to temporary variables, there
could be conflicts with the plotting code. The only way to be sure
of not overriding an important variable would be to understand the
full plotting code, which is far too demanding to justify.)
The solution is for users to draw panels individually, adding
graphical elements with conventional R functions such as \code{\link{lines}},
etc.

}
}
\seealso{
The \sQuote{Bioconductor} scheme for removing functions is
described at
\url{https://www.bioconductor.org/developers/how-to/deprecation/} and it is
extended here to function arguments.
}

