% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce.as.POSIXlt}
\alias{oce.as.POSIXlt}
\title{Oce Variant of as.POSIXlt}
\usage{
oce.as.POSIXlt(x, tz = "")
}
\arguments{
\item{x}{a date, as for \code{as.POSIXlt}, but also including forms in which
the month name appears.}

\item{tz}{the timezone, as for \code{as.POSIXlt}}
}
\value{
A POSIXlt object.
}
\description{
Used in parsing headers, this function is built on the standard
\code{\link{as.POSIXlt}} function.  the only difference is that this also
recognizes dates of forms such as \code{"2002 100 1430"} (year day hhmm),
\code{"Aug 23 2002"}, \code{"August 23 2002"}, \code{"2002 Aug 23"}, and
\code{"2002 23 Aug"}.  (The month may appear in abbreviated form or written
in full, and may be capitalized or not.)
}
\examples{
oce.as.POSIXlt("2016-11-06")
}
\author{
Dan Kelley
}
\seealso{
\code{\link{as.POSIXlt}}, from which this is derived.

Other things related to time: \code{\link{ctimeToSeconds}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{numberAsHMS}},
  \code{\link{numberAsPOSIXct}},
  \code{\link{secondsToCtime}},
  \code{\link{unabbreviateYear}}
}

