% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{vectorShow}
\alias{vectorShow}
\title{Show some values from a vector}
\usage{
vectorShow(v, msg, digits = 5, n = 2L)
}
\arguments{
\item{v}{the vector.}

\item{msg}{a message to show, introducing the vector.  If not provided, then
a message is created from \code{v}.}

\item{digits}{for numerical values of \code{v}, this is the number of digits
to use, in formatting the numbers with \code{\link{format}}; otherwise,
\code{digits} is ignored.}

\item{n}{number of elements to at start and end. If \code{n}
is negative, then all the elements are shown.}
}
\value{
A string, suitable for using in \code{\link{cat}} or
\code{\link{oceDebug}}.
}
\description{
This is similar to \code{\link{str}}, but it shows data at the first and
last of the vector, which can be quite helpful in debugging.
}
\author{
Dan Kelley
}

