% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swPressure}
\alias{swPressure}
\title{Water pressure}
\usage{
swPressure(depth, latitude = 45, eos = getOption("oceEOS", default =
  "gsw"))
}
\arguments{
\item{depth}{distance below the surface in metres.}

\item{latitude}{Latitude in \eqn{^\circ}{deg}N or radians north of the
equator.}

\item{eos}{indication of formulation to be used, either \code{"unesco"} or
\code{"gsw"}.}
}
\value{
Pressure in dbar.
}
\description{
Compute seawater pressure from depth by inverting \code{\link{swDepth}}
using \code{\link{uniroot}}.
}
\details{
If \code{eos="unesco"} this is done by numerical inversion of
\code{\link{swDepth}} is done using \code{\link{uniroot}}. If
\code{eos="gsw"}, it is done using \code{\link[gsw]{gsw_p_from_z}} in the
\code{gsw} package.
}
\examples{
swPressure(9712.653, 30, eos="unesco") # 10000
swPressure(9712.653, 30, eos="gsw")    #  9998.863

}
\references{
Unesco 1983. Algorithms for computation of fundamental
properties of seawater, 1983. \emph{Unesco Tech. Pap. in Mar. Sci.}, No. 44,
53 pp.
}
\seealso{
Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}}, \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swRho}}, \code{\link{swRrho}},
  \code{\link{swSCTp}}, \code{\link{swSTrho}},
  \code{\link{swSigma0}}, \code{\link{swSigma1}},
  \code{\link{swSigma2}}, \code{\link{swSigma3}},
  \code{\link{swSigma4}}, \code{\link{swSigmaTheta}},
  \code{\link{swSigmaT}}, \code{\link{swSigma}},
  \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTFreeze}},
  \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
