% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.odf.R
\name{read.ctd.odf}
\alias{read.ctd.odf}
\title{Read a CTD file in ODF format}
\usage{
read.ctd.odf(file, columns = NULL, station = NULL, missingValue,
  deploymentType = "unknown", monitor = FALSE,
  debug = getOption("oceDebug"), processingLog, ...)
}
\arguments{
\item{file}{A connection or a character string giving the name of the file to
load.  For \code{read.ctd.sbe()} and \code{read.ctd.woce()}, this may be a
wildcard (e.g. \code{"*.cnv"} or \code{"*.csv"}) in which case the return
value is a vector containing CTD objects created by reading the files from
\code{\link{list.files}} with \code{pattern} set to the specified wildcard
pattern.}

\item{columns}{An optional \code{\link{list}} that can be used to convert unrecognized
data names to resultant variable names.  This is used only by
\code{\link{read.ctd.sbe}} and \code{\link{read.ctd.odf}}. For example,
if a data file named salinity as \code{"SAL"}, then using
\preformatted{
d <- read.ctd(f, columns=list(
    salinity=list(name="SAL",
                  unit=list(unit=expression(),
                  scale="PSS-78"))))
}
would assign the \code{"SAL"} column to the \code{salinity} entry in the data
slot of the CTD object returned by the \code{read.*} function.}

\item{station}{Optional character string containing an identifying name or
number for the station. This can be useful if the routine cannot determine the
name automatically, or if another name is preferred.}

\item{missingValue}{Optional missing-value flag; data matching this value will
be set to \code{NA} upon reading. If this is provided, then it overrules any
missing-value flag found in the data. For Seabird (\code{.cnv}) files, there is
usually no need to set \code{missingValue}, because it can be inferred from the
header (typically as -9.990e-29). Set \code{missingValue=NULL} to turn off
missing-value detection, even in \code{.cnv} files that contain missing-value
codes in their headers. If \code{missingValue} is not specified,
then an attempt is made to infer such a value from the data, by testing
whether salinity and/or temperature has a minimum that is under -8 in value;
this should catch common values in files, without false positives. A warning
will be issued in this case, and a note inserted in the processing log of
the return value.}

\item{deploymentType}{character string indicating the type of deployment. Use
\code{"unknown"} if this is not known, \code{"profile"} for a profile (in
which the data were acquired during a downcast, while the device was lowered
into the water column, perhaps also including an upcast; \code{"moored"} if
the device is installed on a fixed mooring, \code{"thermosalinograph"} (or
\code{"tsg"}) if the device is mounted on a moving vessel, to record
near-surface properties, or \code{"towyo"} if the device is repeatedly
lowered and raised.}

\item{monitor}{Boolean, set to \code{TRUE} to provide an indication of
progress.  This is useful if \code{filename} is a wildcard.}

\item{debug}{An integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{processingLog}{If provided, the action item to be stored in the log.
This is typically only provided for internal calls; the default that it provides is
better for normal calls by a user.}

\item{...}{additional arguments, passed to called routines.}
}
\value{
An object of \code{\link{ctd-class}}. The details of the contents
depend on the source file. The \code{metadata} slot is particularly 
variable across data formats, because the meta-information provided
in those formats varies widely.
}
\description{
Read a CTD file in ODF format
}
\details{
\code{read.ctd.odf} reads files stored in Ocean Data Format, used in
some Canadian hydrographic databases.
}
\references{
The ODF format, used by the Canadian Department of Fisheries and Oceans, is
described to some extent in the documentation for \code{\link{read.odf}}.  It
is not clear that ODF format is handled correctly in \code{read.ctd.odf}, or
the more general function \code{\link{read.odf}}, because the format
varies between some sample files the author has encountered in his research.
}
\seealso{
Other things related to ctd data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdDecimate}}, \code{\link{ctdFindProfiles}},
  \code{\link{ctdRaw}}, \code{\link{ctdTrim}},
  \code{\link{ctd}}, \code{\link{handleFlags,ctd-method}},
  \code{\link{initialize,ctd-method}},
  \code{\link{initializeFlagScheme,ctd-method}},
  \code{\link{oceNames2whpNames}},
  \code{\link{oceUnits2whpUnits}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{setFlags,ctd-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}},
  \code{\link{woceUnit2oceUnit}}, \code{\link{write.ctd}}

Other things related to ctd data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdDecimate}}, \code{\link{ctdFindProfiles}},
  \code{\link{ctdRaw}}, \code{\link{ctdTrim}},
  \code{\link{ctd}}, \code{\link{handleFlags,ctd-method}},
  \code{\link{initialize,ctd-method}},
  \code{\link{initializeFlagScheme,ctd-method}},
  \code{\link{oceNames2whpNames}},
  \code{\link{oceUnits2whpUnits}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{setFlags,ctd-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}},
  \code{\link{woceUnit2oceUnit}}, \code{\link{write.ctd}}

Other things related to odf data: \code{\link{ODF2oce}},
  \code{\link{ODFListFromHeader}},
  \code{\link{ODFNames2oceNames}},
  \code{\link{[[,odf-method}},
  \code{\link{[[<-,odf-method}}, \code{\link{odf-class}},
  \code{\link{plot,odf-method}}, \code{\link{read.odf}},
  \code{\link{subset,odf-method}},
  \code{\link{summary,odf-method}}
}
\author{
Dan Kelley
}
\concept{things related to ctd data}
\concept{things related to odf data}
