% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\name{rskPatm}
\alias{rskPatm}
\title{Estimate Atmospheric Pressure in Rsk Object}
\usage{
rskPatm(x, dp = 0.5)
}
\arguments{
\item{x}{A \code{rsk} object, or a list of pressures (in decibars).}

\item{dp}{Half-width of pressure window to be examined (in decibars).}
}
\value{
A list of four estimates: \code{sap}, the median, the mean, and the weighted
mean.
}
\description{
Estimate atmospheric pressure in rsk record.
}
\details{
Pressures must be in decibars for this to work.  First, a subset of pressures is
created, in which the range is \code{sap-dp} to \code{sap+dp}.  Here,
\code{sap}=10.1325 dbar is standard sealevel atmospheric pressure.  Within this
window, three measures of central tendency are calculated: the median, the mean,
and a weighted mean that has weight given by \eqn{exp(-2*((p
    - sap) / dp)^2)}{exp(-2*((p - sap) / dp)^2)}.
}
\examples{
library(oce)
data(rsk)
print(rskPatm(rsk))

}
\seealso{
The documentation for \code{\link{rsk-class}} explains the structure of
\code{rsk} objects, and also outlines the other functions dealing with them.

Other things related to rsk data: \code{\link{[[,rsk-method}},
  \code{\link{[[<-,rsk-method}}, \code{\link{as.rsk}},
  \code{\link{plot,rsk-method}}, \code{\link{read.rsk}},
  \code{\link{rsk-class}}, \code{\link{rskToc}},
  \code{\link{rsk}}, \code{\link{subset,rsk-method}},
  \code{\link{summary,rsk-method}}
}
\author{
Dan Kelley
}
\concept{things related to rsk data}
