% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\name{beamToXyzAdv}
\alias{beamToXyzAdv}
\title{Convert ADV from Beam to XYZ Coordinates}
\usage{
beamToXyzAdv(x, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{adv} object.}

\item{debug}{a flag that, if non-zero, turns on debugging.  Higher values
yield more extensive debugging.}
}
\description{
Convert ADV velocity components from a beam-based coordinate system to a
xyz-based coordinate system.
}
\details{
The coordinate transformation is done using the transformation matrix
contained in \code{transformation.matrix} in the
\code{metadata} slot, which is normally
inferred from the header in the binary file.  If there is no such matrix
(e.g. if the data were streamed through a data logger that did not capture
the header), \code{beamToXyzAdv} the user will need to store one in
\code{x}, e.g. by doing something like the following:\preformatted{x[["transformation.matrix"]] <- rbind(c(11100, -5771, -5321),
                                      c( #' 291, 9716, -10002),
                                      c( 1409, 1409, 1409)) / 4096
}
}
\references{
\enumerate{
\item @template nortekCoordTemplate
}
}
\seealso{
See \code{\link[=read.adv]{read.adv()}} for notes on functions relating to
\code{"adv"} objects.

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
