% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{adpEnsembleAverage}
\alias{adpEnsembleAverage}
\title{Ensemble Average an ADP Object in Time}
\usage{
adpEnsembleAverage(x, n = 5, leftover = FALSE, na.rm = TRUE, ...)
}
\arguments{
\item{x}{an \linkS4class{adp} object.}

\item{n}{number of pings to average together.}

\item{leftover}{a logical value indicating how to proceed in cases
where \code{n} does not divide evenly into the number of ensembles
in \code{x}. If \code{leftover} is \code{FALSE} (the default) then any extra
ensembles at the end of \code{x} are ignored. Otherwise, they are used
to create a final ensemble in the returned value.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds}

\item{...}{extra arguments to be passed to the \code{mean()} function.}
}
\value{
A new \linkS4class{adp} object with ensembles averaged as specified. E.g. for an \code{adp} object with 100 pings and \code{n=5} the number of rows of the data arrays will be reduced by a factor of 5.
}
\description{
Ensemble averaging of \code{adp} objects is often necessary to
reduce the uncertainty in velocity estimates from single
pings. Many types of ADPs can be configured to perform the
ensemble averaging during the data collection, due to memory
limitations for long deployments. In cases where the instrument is
not memory limited, it may be desirable to perform the ensemble
averaging during post-processing, thereby reducing the overall
size of the data set and decreasing the uncertainty of the
velocity estimates (by averaging out Doppler noise).
}
\examples{
library(oce)
data(adp)
adpAvg <- adpEnsembleAverage(adp, n=2)
plot(adpAvg)

}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Clark Richards and Dan Kelley
}
\concept{things related to adp data}
