% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{plot,tidem-method}
\alias{plot,tidem-method}
\alias{plot.tidem}
\title{Plot a tidem Object}
\usage{
\S4method{plot}{tidem}(
  x,
  which = 1,
  constituents = c("SA", "O1", "K1", "M2", "S2", "M4"),
  sides = NULL,
  col = "blue",
  log = "",
  mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 1, mgp[1] + 1, mgp[2] + 0.25, mgp[2] + 1),
  ...
)
}
\arguments{
\item{x}{a \linkS4class{tidem} object.}

\item{which}{integer flag indicating plot type, 1 for stair-case spectral, 2
for spike spectral.}

\item{constituents}{character vector holding the names of constituents that are
to be drawn and labelled. If \code{NULL}, then no constituents will be shown.}

\item{sides}{an integer vector of length equal to that of \code{constituents},
designating the side on which the constituent labels are to be drawn. As in
all R graphics, the value \code{1} indicates the bottom of the plot, and
\code{3} indicates the top. If \code{sides=NULL}, the default, then all labels
are drawn at the top. Any value of \code{sides} that is not either 1 or 3
is converted to 3.}

\item{col}{a character vector naming colors to be used for \code{constituents}.
Ignored if \code{sides=3}. Repeated to be of the same length as
\code{constituents}, otherwise.}

\item{log}{if set to "\code{x}", the frequency axis will be logarithmic.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{[}par\verb{]("mar")}.}

\item{\dots}{optional arguments passed to plotting functions, not all
of which are obeyed.  For example, if \dots contains \code{type}, that value will be
ignored because it is set internally, according to the value of \code{which}.}
}
\description{
Plot a summary diagram for a tidal fit.
}
\section{Historical note}{

An argument named \code{labelIf} was removed in July 2016,
because it was discovered never to have worked as documented, and
because the more useful argument \code{constituents} had been added.
}

\examples{
\dontrun{
library(oce)
data(sealevel)
tide <- tidem(sealevel)
plot(tide)
}

}
\seealso{
Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{predict.tidem}()},
\code{\link{summary,tidem-method}},
\code{\link{tidalCurrent}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemAstron}()},
\code{\link{tidemVuf}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to tides}
