% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf.R
\name{read.netcdf}
\alias{read.netcdf}
\title{Read a NetCDF File}
\usage{
read.netcdf(file, ..., encoding = NA, debug = getOption("oceDebug"))
}
\arguments{
\item{file}{the name of a file}

\item{...}{ignored}

\item{encoding}{ignored.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
An \linkS4class{oce} object.
}
\description{
Read a netcdf file, trying to interpret its contents sensibly.
}
\details{
It is important to note that this is a preliminary version of
this function, and much about it may change without notice.
Indeed, it may be removed entirely.

Below are some features that may be changed.
\enumerate{
\item The names of data items are not changed from those in the netcdf
file on the assumption that this will offer the least surprise to
the user.
\item An attempt is made to find some common metadata from global
attributes in the netcdf file. These attributes include
\code{Longitude}, \code{Latitude}, \code{Ship} and \code{Cruise}.
Before they are stored in the metadata, they are converted to
lower case, since that is the oce convention.
}
}
