% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson.R
\docType{methods}
\name{poissonProb}
\alias{poissonProb}
\title{Compute predictive probabilities based on Poisson}
\usage{
poissonProb(update_params0, update_paramsT, datapt, time, cps, missPts,
  Rlength, skippt = FALSE)
}
\arguments{
\item{update_params0}{The initialization parameters,
corresponding to predicting a changepoint (run length=0)}

\item{update_paramsT}{The vectors of parameters corresponding
to each possible run length, updated with each incoming data point}

\item{datapt}{the current data point}

\item{time}{the number of time points passed so far}

\item{cps}{the current most likely list of changepoints}

\item{missPts}{the method set to handle missing points}

\item{Rlength}{the length of the current vector of possible run
lengths}

\item{skippt}{If the current point should be skipped in the updating
because it was missing, and missPts was set to skip}
}
\value{
Returns a vector of predictive
probabilities from each possible run length, the
parameters of the gaussian, the most likely mean of the
current gaussian, and the current point.
}
\description{
Compute the probability of observing the current point,
given the current parameters of the poisson for each
possible run length. Returns a vector of predictive
probabilities from each possible run length, the
parameters of the poisson, the most likely lambda of the
current poisson, and the current point.
}
