% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{od_aggregate}
\alias{od_aggregate}
\alias{od_group}
\title{Aggregate od pairs based on aggregating zones}
\usage{
od_aggregate(od, aggzones = NULL, FUN = sum)

od_group(od, aggzones = NULL, FUN = sum)
}
\arguments{
\item{od}{An origin-destination data frame}

\item{aggzones}{Points within the zones defining the OD data}

\item{FUN}{The aggregating function to use}
}
\description{
This function is for aggregating OD pairs.
It generally decreases the number of rows in an OD dataset, while aiming
to keep the amount of travel represented in the data the same.
}
\details{
An alias for the function is \code{od_group()}.
}
\examples{
od_aggregated = od_data_df[1:2, ]
aggzones = od::od_data_zones_min
subzones = od_data_zones_small
plot(aggzones$geometry)
plot(subzones$geometry, add = TRUE)
od = od_disaggregate(od_aggregated, aggzones, subzones)
od_agg = od_aggregate(od, aggzones)
names(od_agg)[1:(ncol(od_agg) - 1)] = names(od_aggregated)
attr(od_aggregated, "spec") = NULL
identical(sf::st_drop_geometry(od_agg), od_aggregated)
}
