% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-result.R
\docType{methods}
\name{OdbcResult}
\alias{OdbcResult}
\alias{OdbcResult-class}
\alias{dbClearResult,OdbcResult-method}
\alias{dbFetch,OdbcResult-method}
\alias{dbHasCompleted,OdbcResult-method}
\alias{dbIsValid,OdbcResult-method}
\alias{dbGetStatement,OdbcResult-method}
\alias{dbColumnInfo,OdbcResult-method}
\alias{dbGetRowCount,OdbcResult-method}
\alias{dbGetRowsAffected,OdbcResult-method}
\alias{dbBind,OdbcResult-method}
\title{Odbc Result Methods}
\usage{
\S4method{dbClearResult}{OdbcResult}(res, ...)

\S4method{dbFetch}{OdbcResult}(res, n = -1, ...)

\S4method{dbHasCompleted}{OdbcResult}(res, ...)

\S4method{dbIsValid}{OdbcResult}(dbObj, ...)

\S4method{dbGetStatement}{OdbcResult}(res, ...)

\S4method{dbColumnInfo}{OdbcResult}(res, ...)

\S4method{dbGetRowCount}{OdbcResult}(res, ...)

\S4method{dbGetRowsAffected}{OdbcResult}(res, ...)

\S4method{dbBind}{OdbcResult}(res, params, ..., batch_rows = getOption("odbc.batch_rows", NA))
}
\arguments{
\item{res}{An object inheriting from \link[DBI:DBIResult-class]{DBI::DBIResult}.}

\item{...}{Other arguments passed on to methods.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{dbObj}{An object inheriting from \code{DBIObject}, i.e. \code{DBIDriver},
\code{DBIConnection}, or a \code{DBIResult}.}

\item{params}{For \code{dbBind()}, a list of values, named or unnamed,
or a data frame, with one element/column per query parameter.
For \code{dbBindArrow()}, values as a nanoarrow stream,
with one column per query parameter.}

\item{batch_rows}{The number of rows to retrieve. Defaults to \code{NA}, which
is set dynamically to the minimum of 1024 and the size of the input.
Depending on the database, driver, dataset and free memory, setting this
to a lower value may improve performance.}
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package
for OdbcResult objects.
}
\keyword{internal}
