% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.ratio.gam.R
\name{calc.oddsratio.gam}
\alias{calc.oddsratio.gam}
\title{Calculate Odds Ratio of Generalized Additive (Mixed) Models}
\usage{
calc.oddsratio.gam(data, model, pred, values, percentage, slice = FALSE)
}
\arguments{
\item{data}{The data used for model fitting.}

\item{model}{A fitted GAM(M).}

\item{pred}{Character of length one. The name of the predictor to calculate 
the odds ratio for.}

\item{values}{Numeric vector of length two.
Predictor values to estimate odds ratio from. Function is written to use the 
first provided value as the "lower" one, i.e. calculating the odds ratio 
'from value1 to value2'. Only used if \code{slice = FALSE}.}

\item{percentage}{Numeric of length one. Percentage number to split the 
predictor distribution into. 
A value of 10 would split the predictor distribution by 10\% intervals. 
Only needed if \code{slice = TRUE}.}

\item{slice}{Logical. \code{Default = FALSE}. Whether to calculate 
odds ratios for fixed increment steps over the whole predictor distribution. 
See \code{percentage} for setting the increment values.}
}
\value{
A data frame with (up to) six columns. \code{perc1} and \code{perc1}
are only returned if \code{slice = TRUE}:
\item{predictor}{Predictor name}
\item{value1}{First value of odds ratio calculation}
\item{value2}{Second value of odds ratio calculation}
\item{perc1}{Percentage value of \code{value1}}
\item{perc2}{Percentage value of \code{value2}}
\item{oddsratio}{Calculated odds ratio(s)}
}
\description{
This function to calculates odds ratio(s) for specific increment 
    steps of a GAM(M)s.

Odds ratios can also be calculated for continuous percentage increment steps 
    across the whole predictor distribution using \code{slice = TRUE}.
}
\details{
Currently supported functions: \code{\link[mgcv]{gam}}(mgcv), 
\code{\link[mgcv]{gamm}}, \code{\link[gam]{gam}}(gam).

For \code{\link[mgcv]{gamm}}, the \code{model} input of 
\code{\link[oddsratio]{calc.oddsratio.gam}} needs to be the \code{gam} 
output (e.g. \code{fit.gam$gam}).
}
\examples{
# load data (Source: ?mgcv::gam)
library(mgcv)
n <- 200
sig <- 2
dat <- gamSim(1, n = n,scale = sig, verbose = FALSE)
dat$x4 <- as.factor(c(rep("A", 50), rep("B", 50), rep("C", 50), rep("D", 50)))
fit.gam <- gam(y ~ s(x0) + s(I(x1^2)) + s(x2) + 
               offset(x3) + x4, data = dat) # fit model

# Calculate OR for specific increment step of continuous variable
calc.oddsratio.gam(data = dat, model = fit.gam, pred = "x2", 
                   values = c(0.099, 0.198))

## Calculate OR for change of indicator variable
calc.oddsratio.gam(data = dat, model = fit.gam, pred = "x4", 
                   values = c("B", "D"))

## Calculate ORs for percentage increments of predictor distribution (here: 20\%)
calc.oddsratio.gam(data = dat, model = fit.gam, pred = "x2", 
                   percentage = 20, slice = TRUE)

}
\seealso{
\code{\link[oddsratio]{calc.oddsratio.glm}}
}

