% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.oddsratio.glm.R
\name{calc.oddsratio.glm}
\alias{calc.oddsratio.glm}
\title{Calculate odds ratios of Generalized Linear (Mixed) Models}
\usage{
calc.oddsratio.glm(data, model, incr, CI = 0.95)
}
\arguments{
\item{data}{The data used for model fitting.}

\item{model}{A fitted GLM(M).}

\item{incr}{List. Increment values of each predictor.}

\item{CI}{numeric. Which confident interval to calculate. 
Must be between 0 and 1. Default to 0.95}
}
\value{
A data frame with five columns:
\item{predictor}{Predictor name(s)}
\item{oddsratio}{Calculated odds ratio(s)}
\item{CI.low}{Lower confident interval of odds ratio}
\item{CI.high}{Higher confident interval of odds ratio}
\item{increment}{Increment of the predictor(s)}
}
\description{
This function calculates odds ratio(s) for specific 
    increment steps of GLMs.
}
\details{
\code{CI.low} and {CI.high} are only calculted for GLM models because 
\code{\link[MASS]{glmmPQL}} does not return confident intervals due to its penalizing
behaviour.

Currently supported functions: \code{\link[stats]{glm}}, 
\code{\link[MASS]{glmmPQL}}
}
\examples{
## Example with stats::glm()
# load data (source: http://www.ats.ucla.edu/stat/r/dae/logit.htm) and fit model
fit.glm <- glm(admit ~ gre + gpa + rank, data = data.glm, family = "binomial") # fit model

# Calculate OR for specific increment step of continuous variable
calc.oddsratio.glm(data = data.glm, model = fit.glm, incr = list(gre = 380, gpa = 5))

# Calculate OR and change the confidence interval level
calc.oddsratio.glm(data = data.glm, model = fit.glm, 
                   incr = list(gre = 380, gpa = 5), CI = .70)

## Example with MASS:glmmPQL()
# load data
library(MASS)
data(bacteria)
fit.glmmPQL <- MASS::glmmPQL(y ~ trt + week, random = ~1 | ID,
                             family = binomial, data = bacteria, verbose = FALSE)

# Apply function
calc.oddsratio.glm(data = bacteria, model = fit.glmmPQL, incr = list(week = 5))

}
\author{
Patrick Schratz <patrick.schratz@gmail.com>
}
\seealso{
\code{\link[oddsratio]{calc.oddsratio.gam}}
}

