% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odin_parse.R
\name{odin_parse}
\alias{odin_parse}
\alias{odin_parse_}
\title{Parse an odin model}
\usage{
odin_parse(x, type = NULL, options = NULL)

odin_parse_(x, options = NULL, type = NULL)
}
\arguments{
\item{x}{An expression, character vector or filename with the odin
code}

\item{type}{An optional string indicating the the type of input -
must be one of \code{expression}, \code{file} or \code{text} if
provided.  This skips the type detection code used by odin and
makes validating user input easier.}

\item{options}{odin options; see \link{odin_options}.  The
primary options that affect the parse stage are \code{validate}
and \code{pretty}.}
}
\description{
Parse an odin model, returning an intermediate representation.
The \code{odin_parse_} version is a "standard evaluation" escape
hatch.
}
\details{
A schema for the intermediate representation is available in the
package as \code{schema.json}.  It is subject to change at this
point.
}
\examples{
# Parse a model of exponential decay
ir <- odin::odin_parse({
  deriv(y) <- -0.5 * y
  initial(y) <- 1
})

# This is odin's intermediate representation of the model
ir

# If parsing odin models programmatically, it is better to use
# odin_parse_; construct the model as a string, from a file, or as a
# quoted expression:
code <- quote({
  deriv(y) <- -0.5 * y
  initial(y) <- 1
})

odin::odin_parse_(code)
}
\seealso{
\link{odin_validate}, which wraps this function
where parsing might fail, and \link{odin_build} for
building odin models from an intermediate representation.
}
