% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleChoiceExpand.R
\name{expandMultChoice}
\alias{expandMultChoice}
\title{expandMultChoice}
\usage{
expandMultChoice(answers, choices = NULL, naCode = NULL,
  naQuestion = NULL)
}
\arguments{
\item{answers}{Character vector with given answers (strings containing the
choices)}

\item{choices}{(optional) Character vector with choices to be used (each will
become a column). If not supplied, choices will be determined from the
\code{answer} parameter, splitting given answers by an empty space
\code{(" ")} and finding unique values.}

\item{naCode}{(optional) Single element specifying what character code
equates to \code{NA}}

\item{naQuestion}{(optional) TRUE/FALSE vector of the same length as answers;
in rows where this is false, all columns will be coded as \code{NA}}
}
\value{
a data frame with multiple separate 0/1 columns
}
\description{
Function to recode a choose-multiple column where multiple answers are
recorded in the same element (e.g. "ab ac ad", "ef eg eh") to a data frame
with multiple separate 0/1 columns e.g.:
}
\details{
ab  ac  ad  ef  eg  eh
[1,]  1   1   1   0   0   0
[2,]  0   0   0   1   1   1
}
\section{NOTE}{
 \code{naCode} must exist as the only answer in a column (an answer that
contains both a valid answer and the \code{NA} code will not be recognized as
\code{NA} - instead, the \code{NA} code will be output as an extra answer
column (if \code{choices} parameter is not given))
}

\examples{
# Expand responses in variable w7 of sampleData2
sampleData2 <- renameODK(sampleData2)
temp <- expandMultChoice(sampleData2$ws7)

}
