% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_covariance_matrix.R
\name{check_covariance_matrix}
\alias{check_covariance_matrix}
\alias{assert_covariance_matrix}
\alias{test_covariance_matrix}
\title{Check if an argument is a covariance matrix}
\usage{
check_covariance_matrix(x, dim = NULL, tolerance = sqrt(.Machine$double.eps))

assert_covariance_matrix(
  x,
  dim = NULL,
  tolerance = sqrt(.Machine$double.eps),
  .var.name = checkmate::vname(x),
  add = NULL
)

test_covariance_matrix(x, dim = NULL, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{Object to check.}

\item{dim}{An \code{integer}, the matrix dimension.}

\item{tolerance}{A non-negative \code{numeric} tolerance value.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Compare to \code{\link[checkmate]{check_matrix}}.
}
\description{
This function checks whether the input is a symmetric, real matrix that
fulfills the covariance matrix properties.
}
