% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_logo.R
\name{package_logo}
\alias{package_logo}
\title{Creating a basic logo for an R package}
\usage{
package_logo(package_name, brackets = TRUE, use_logo = FALSE)
}
\arguments{
\item{package_name}{A \code{character}, the package name.}

\item{brackets}{Set to \code{TRUE} (default) to have curly brackets around the package name.}

\item{use_logo}{Set to \code{TRUE} to run \code{\link[usethis]{use_logo}} in the end.}
}
\value{
A \code{ggplot} object.
}
\description{
This function creates a basic R package logo. The logo has a white
background and the package name (with or without curly brackets) in the
center. The font size for the package name is scaled such that it fits inside
the logo. Type \code{?oeli} to see an example.

The function optionally calls \code{\link[usethis]{use_logo}} if
\code{use_logo = TRUE} to set up the logo for a package.
}
\examples{
package_logo("my_package", brackets = TRUE, use_logo = FALSE)
}
