% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_check_response.R
\name{input_check_response}
\alias{input_check_response}
\title{Standardized response to an input check}
\usage{
input_check_response(
  check,
  var_name = NULL,
  error = TRUE,
  prefix = "Input {.var {var_name}} is bad:"
)
}
\arguments{
\item{check}{[\code{TRUE} | \code{character(1)}]\cr
Matches the return value of the \verb{check*} functions from the \code{{checkmate}}
package, i.e., either \code{TRUE} if the check was successful, or a \code{character}
(the error message) else.}

\item{var_name}{[\code{NULL} | \code{character(1)}]\cr
Optionally specifies the name of the input being checked. This name will be
used for the default value of the \code{prefix} argument.}

\item{error}{[\code{logical(1)}]\cr
If \code{check} is not \code{TRUE}, throw an error?}

\item{prefix}{[\code{character(1)}]\cr
A prefix for the thrown error message, if \code{check} is not \code{TRUE} and
\code{error} is \code{TRUE}.}
}
\value{
\code{TRUE} if \code{check} is \code{TRUE}. If \code{check} is not \code{TRUE}, depending on \code{error}:
\itemize{
\item If \code{error} is \code{TRUE}, throws an error.
\item If \code{error} is \code{FALSE}, returns \code{FALSE}.
}
}
\description{
This function provides standardized responses to input checks, ensuring
consistency.
}
\examples{
x <- "1"
y <- 1

### check is successful
input_check_response(
  check = checkmate::check_character(x),
  var_name = "x",
  error = TRUE
)

### standardized check response
\dontrun{
input_check_response(
  check = checkmate::check_character(y),
  var_name = "y",
  error = TRUE
)
}
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{identical_structure}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{renv_development_packages}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
