% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_section.R
\name{body_end_section}
\alias{body_end_section}
\alias{body_default_section}
\alias{break_column_before}
\title{add section}
\usage{
body_end_section(x, landscape = FALSE, margins = c(top = NA, bottom = NA,
  left = NA, right = NA), colwidths = c(1), space = 0.05, sep = FALSE,
  continuous = FALSE)

body_default_section(x, landscape = FALSE, margins = c(top = NA, bottom =
  NA, left = NA, right = NA))

break_column_before(x)
}
\arguments{
\item{x}{an rdocx object}

\item{landscape}{landscape orientation}

\item{margins}{a named vector of margin settings in inches, margins not set remain at their default setting}

\item{colwidths}{columns widths as percentages, summing to 1. If 3 values, 3 columns
will be produced.}

\item{space}{space in percent between columns.}

\item{sep}{if TRUE a line is separating columns.}

\item{continuous}{TRUE for a continuous section break.}
}
\description{
add a section in a Word document. A section affects
preceding paragraphs or tables.
}
\details{
A section starts at the end of the previous section (or the beginning of
the document if no preceding section exists), and stops where the section is declared.
The function \code{body_end_section()} is reflecting that Word concept.
The function \code{body_default_section()} is only modifying the default section of
the document.
}
\examples{
library(magrittr)

str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. " \%>\%
  rep(10) \%>\% paste(collapse = "")

my_doc <- read_docx() \%>\%
  # add a paragraph
  body_add_par(value = str1, style = "Normal") \%>\%
  # add a continuous section
  body_end_section(continuous = TRUE) \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  # preceding paragraph is on a new column
  break_column_before() \%>\%
  # add a two columns continous section
  body_end_section(colwidths = c(.6, .4),
                   space = .05, sep = FALSE, continuous = TRUE) \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  # add a continuous section ... so far there is no break page
  body_end_section(continuous = TRUE) \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  body_default_section(landscape = TRUE, margins = c(top = 0.5, bottom = 0.5))

print(my_doc, target = "section.docx")
}
