% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{read_pptx}
\alias{read_pptx}
\alias{print.rpptx}
\alias{length.rpptx}
\title{open a connexion to a 'PowerPoint' file}
\usage{
read_pptx(path = NULL)

\method{print}{rpptx}(x, target = NULL, ...)

\method{length}{rpptx}(x)
}
\arguments{
\item{path}{path to the pptx file to use as base document.}

\item{x}{an rpptx object}

\item{target}{path to the pptx file to write}

\item{...}{unused}
}
\description{
read and import a pptx file as an R object
representing the document.
}
\section{number of slides}{

Function \code{length} will return the number of slides.
}

\examples{
read_pptx()
# write a rdocx object in a docx file ----
if( require(magrittr) ){
  file <- tempfile(fileext = ".pptx")
  read_pptx() \%>\% print(target = file)
  # full path of produced file is returned
  print(.Last.value)
}
}
