% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{plot_instr}
\alias{plot_instr}
\title{Wrap plot instructions for png plotting in Powerpoint or Word}
\usage{
plot_instr(code)
}
\arguments{
\item{code}{plotting instructions}
}
\description{
A simple wrapper to capture
plot instructions that will be executed and copied in a document. It produces
an object of class 'plot_instr' with a corresponding method \code{\link[=ph_with]{ph_with()}}.

The function enable usage of any R plot with argument \code{code}. Wrap your code
between curly bracket if more than a single expression.
}
\examples{

# plot_instr demo ----

anyplot <- plot_instr(code = {
  barplot(1:5, col = 2:6)
  })

doc <- read_docx()
doc <- body_add(doc, anyplot, width = 5, height = 4)
print(doc, target = tempfile(fileext = ".docx"))


doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(
  doc, anyplot,
  location = ph_location_fullsize(),
  bg = "#00000066", pointsize = 12)
print(doc, target = tempfile(fileext = ".pptx"))
}
\seealso{
\code{\link[=ph_with]{ph_with()}}, \code{\link[=body_add]{body_add()}}

Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
