% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{plot_layout_properties}
\alias{plot_layout_properties}
\title{Slide layout properties plot}
\usage{
plot_layout_properties(x, layout = NULL, master = NULL, labels = TRUE)
}
\arguments{
\item{x}{an rpptx object}

\item{layout}{slide layout name to use}

\item{master}{master layout name where \code{layout} is located}

\item{labels}{if TRUE, placeholder labels will be printed, if FALSE
placeholder types and identifiers will be printed.}
}
\description{
Plot slide layout properties and print informations
into defined placeholders. This can be useful to help
visualise placeholders locations and identifier.
}
\examples{
x <- read_pptx()
plot_layout_properties( x = x, layout = "Title Slide",
  master = "Office Theme" )
plot_layout_properties( x = x, layout = "Two Content" )
}
\seealso{
Other functions for reading presentation informations: 
\code{\link{annotate_base}()},
\code{\link{color_scheme}()},
\code{\link{layout_properties}()},
\code{\link{layout_summary}()},
\code{\link{length.rpptx}()},
\code{\link{slide_size}()},
\code{\link{slide_summary}()}
}
\concept{functions for reading presentation informations}
