% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{diving}
\alias{diving}
\title{Olympic Diving Data}
\format{
A \code{data.frame} object with 695 observations and 13 columns. 

The columns are defined as follows:
\describe{
\item{\code{Name}}{The participant's name.}
\item{\code{Age}}{The age of the participant at the time of the Olympics. Some values missing.}
\item{\code{Height}}{The height of the participant at the time of the Olympics, in centimeters. Many values missing.}
\item{\code{Weight}}{The height of the participant at the time of the Olympics, in kilograms. Many values missing.}
\item{\code{Team}}{The string name of the team (country) which the participant represented.}
\item{\code{NOC}}{The string name of the National Olympic Committee which the participant represented. This is a three character code.}
\item{\code{Games}}{The string name of the Olympic games, including a year.}
\item{\code{Year}}{The integer year of the Olympics. These range from 1906
through 2016.}
\item{\code{City}}{The string name of the host city.}
\item{\code{Medal}}{A string of \dQuote{Gold}, \dQuote{Silver},
\dQuote{Bronze} or \code{NA}.}
\item{\code{EventId}}{A unique integer ID for each Olympics.}
\item{\code{AthleteId}}{A unique integer ID for each participant.}
\item{\code{HOST_NOC}}{The string name of the National Olympic Committee of the nation hosting the Olympics. This is a three character code.}
}
}
\source{
Data were collected by Randi Griffin from the website
\dQuote{sports-reference.com}, and staged on Kaggle at
\url{https://www.kaggle.com/heesoo37/120-years-of-olympic-history-athletes-and-results}.
}
\usage{
data(diving)
}
\description{
One hundred years of Men's Olympic Platform Diving records.
}
\note{
The author makes no guarantees regarding correctness of this data.

Please attribute this data to the upstream harvester.
}
\examples{

library(dplyr)
library(forcats)
data(diving)

fitdat <- diving \%>\%
  mutate(Finish=case_when(grepl('Gold',Medal)   ~ 1,
                          grepl('Silver',Medal) ~ 2,
                          grepl('Bronze',Medal) ~ 3,
                          TRUE ~ 4)) \%>\%
  mutate(weight=ifelse(Finish <= 3,1,0)) \%>\%
  mutate(cut_age=cut(coalesce(Age,22.0),c(12,19.5,21.5,22.5,25.5,99),include.lowest=TRUE)) \%>\%
  mutate(country=forcats::fct_relevel(forcats::fct_lump(factor(NOC),n=5),'Other')) \%>\%
  mutate(home_advantage=NOC==HOST_NOC)

hensm(Finish ~ cut_age + country + home_advantage,data=fitdat,weights=weight,group=EventId,ngamma=3)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{data}
