# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Generate Multinomial Random Variable
#' @description Sample a multinomial random variable for given probabilities.
#' @usage rmultinomial(ps)
#' @param ps A \code{vector} for the probability of each category.
#' @return A \code{vector} from a multinomial with probability ps.
#' @author Steven Andrew Culpepper
#' @noRd
NULL

#' @title Generate Dirichlet Random Variable
#' @description Sample a Dirichlet random variable.
#' @usage rDirichlet(deltas)
#' @param deltas A \code{vector} of Dirichlet parameters.
#' @return A \code{vector} from a Dirichlet.
#' @author Steven Andrew Culpepper
#' @noRd
NULL

#' Generate a vector to map polytomous vector to integers
#'
#' Converts class into a bijection to integers
#'
#' @param K      Number of Attributes
#' @param M      Number of Response Categories
#'
#' @return
#'
#' Return a \eqn{K}-length vector containing the bijection vector.
#'
#' @export
gen_bijectionvector <- function(K, M) {
    .Call(`_ohoegdm_gen_bijectionvector`, K, M)
}

inv_gen_bijectionvector <- function(K, M, CL) {
    .Call(`_ohoegdm_inv_gen_bijectionvector`, K, M, CL)
}

CL_gen_invbijection_table <- function(K, M, nClass) {
    .Call(`_ohoegdm_CL_gen_invbijection_table`, K, M, nClass)
}

ETAmat <- function(K, J, M, Q) {
    .Call(`_ohoegdm_ETAmat`, K, J, M, Q)
}

rTruncNorm_lb <- function(mean, sd, b_lb) {
    .Call(`_ohoegdm_rTruncNorm_lb`, mean, sd, b_lb)
}

rTruncNorm <- function(mean, sd, w, ps) {
    .Call(`_ohoegdm_rTruncNorm`, mean, sd, w, ps)
}

random_Q <- function(J, K) {
    .Call(`_ohoegdm_random_Q`, J, K)
}

#' Simulate Ordinal Item Data from a Sparse Latent Class Model
#' 
#' @param N      Number of Observations
#' @param J      Number of Items
#' @param M      Number of Item Categories (2, 3,  ..., M)
#' @param nClass Number of Latent Classes 
#' @param CLASS  A vector of \eqn{N} observations containing the class ID of the
#'               subject.
#' @param Atable A matrix of dimensions \eqn{M^K \times M^O} containing 
#'               the attribute classes in bijection-form. Note, \eqn{O} refers
#'               to the model's highest interaction order.
#' @param BETA   A matrix of dimensions \eqn{J \times M^K} containing the 
#'               coefficients of the reparameterized \eqn{\beta} matrix.
#' @param KAPPA  A matrix of dimensions \eqn{J \times M} containing the 
#'               category threshold parameters
#' 
#' @return 
#' An ordinal item matrix of dimensions \eqn{N \times J}{N x J} with \eqn{M}
#' response levels.
#' 
#' @seealso [ohoegdm]
#' @export
sim_slcm <- function(N, J, M, nClass, CLASS, Atable, BETA, KAPPA) {
    .Call(`_ohoegdm_sim_slcm`, N, J, M, nClass, CLASS, Atable, BETA, KAPPA)
}

BetatoTheta <- function(J, nClass, beta, Atable) {
    .Call(`_ohoegdm_BetatoTheta`, J, nClass, beta, Atable)
}

computePYaj <- function(J, M, nClass, ABETAj, KAPPAj) {
    .Call(`_ohoegdm_computePYaj`, J, M, nClass, ABETAj, KAPPAj)
}

computePYa <- function(J, M, nClass, Atable, BETA, KAPPA) {
    .Call(`_ohoegdm_computePYa`, J, M, nClass, Atable, BETA, KAPPA)
}

slcm_m2LL <- function(N, J, M, nClass, Y, pis, PY_a) {
    .Call(`_ohoegdm_slcm_m2LL`, N, J, M, nClass, Y, pis, PY_a)
}

Pa1 <- function(K, theta, lambda0, lambda1) {
    .Call(`_ohoegdm_Pa1`, K, theta, lambda0, lambda1)
}

slcm_m2LL_HO <- function(N, J, M, nClass, K, Y, theta, Tau, lambda, PY_a, CLtable) {
    .Call(`_ohoegdm_slcm_m2LL_HO`, N, J, M, nClass, K, Y, theta, Tau, lambda, PY_a, CLtable)
}

slcm_LLj <- function(N, M, nClass, Yj, CLASS, PY_ajast, PY_ajtm1) {
    .Call(`_ohoegdm_slcm_LLj`, N, M, nClass, Yj, CLASS, PY_ajast, PY_ajtm1)
}

slcm_LLjm <- function(N, M, m, nClass, Yj, CLASS, PY_ajast, PY_ajtm1) {
    .Call(`_ohoegdm_slcm_LLjm`, N, M, m, nClass, Yj, CLASS, PY_ajast, PY_ajtm1)
}

sampleTauast <- function(M, Kaps, sdMH) {
    .Call(`_ohoegdm_sampleTauast`, M, Kaps, sdMH)
}

computeLowerBound_Bp <- function(nClass, LowerAdjTable, Atable, p, betaj, Bp) {
    .Call(`_ohoegdm_computeLowerBound_Bp`, nClass, LowerAdjTable, Atable, p, betaj, Bp)
}

computeLB <- function(nClass, LBtable, Atable, p, betaj, Bp, Bindices) {
    .Call(`_ohoegdm_computeLB`, nClass, LBtable, Atable, p, betaj, Bp, Bindices)
}

identify_check <- function(Q) {
    .Call(`_ohoegdm_identify_check`, Q)
}

lambda_sample <- function(K, lambda, m_lam, v_lam) {
    invisible(.Call(`_ohoegdm_lambda_sample`, K, lambda, m_lam, v_lam))
}

sampleTauYast <- function(N, J, M, nClass, Y, KAPPA, Yast, ABETA, PY_a, CLASS, MHaccept, sdMH) {
    invisible(.Call(`_ohoegdm_sampleTauYast`, N, J, M, nClass, Y, KAPPA, Yast, ABETA, PY_a, CLASS, MHaccept, sdMH))
}

Q_prime_matrix <- function(K, Atable, vv) {
    .Call(`_ohoegdm_Q_prime_matrix`, K, Atable, vv)
}

eta_dina_matrix <- function(Q) {
    .Call(`_ohoegdm_eta_dina_matrix`, Q)
}

pnorm_ln_upper_tail <- function(B_p_lowerbound, sigma_var_jp) {
    .Call(`_ohoegdm_pnorm_ln_upper_tail`, B_p_lowerbound, sigma_var_jp)
}

q_to_delta <- function(Q, Q_prime, M) {
    .Call(`_ohoegdm_q_to_delta`, Q, Q_prime, M)
}

update_slipping_guessing <- function(slipping, guessing, ab_tilde) {
    invisible(.Call(`_ohoegdm_update_slipping_guessing`, slipping, guessing, ab_tilde))
}

parm_update_nomiss <- function(N, J, K, nClass, M, Y, Yast, BETA, KAPPA, CLASS, theta, lambda, Tau, Q, DELTA, Q_prime, ETA_prime, slipping, guessing, omega, vv, CLtable, Atable, LBtable, Bindices, qtable, P, l1, m0, l0, bq, ABETA, ABETA_sqnorm, PY_a, MHaccept, sdMH, loglike) {
    .Call(`_ohoegdm_parm_update_nomiss`, N, J, K, nClass, M, Y, Yast, BETA, KAPPA, CLASS, theta, lambda, Tau, Q, DELTA, Q_prime, ETA_prime, slipping, guessing, omega, vv, CLtable, Atable, LBtable, Bindices, qtable, P, l1, m0, l0, bq, ABETA, ABETA_sqnorm, PY_a, MHaccept, sdMH, loglike)
}

kappa_initialize <- function(M, J) {
    .Call(`_ohoegdm_kappa_initialize`, M, J)
}

#' Generate tables that store different design elements
#' 
#' Each table provides a "cache" of pre-computed values.
#' 
#' @param nClass   Number of Attribute Classes
#' @param M        Number of Responses
#' @param K        Number of Attributes
#' @param order    Highest interaction order to consider. 
#'                 Default model-specified `k`.
#'
#' @return
#' Return a `list` containing the table caches for different parameters
#'
#' @details
#' This is **an internal function** briefly used to simulate data and, thus, has
#' been exported into _R_ as well as documented. **Output from this function can
#' change in future versions.**
#' 
#' @export
GenerateAtable <- function(nClass, K, M, order) {
    .Call(`_ohoegdm_GenerateAtable`, nClass, K, M, order)
}

QfromD <- function(J, K, DELTA, DtoQtable) {
    .Call(`_ohoegdm_QfromD`, J, K, DELTA, DtoQtable)
}

permuteAtableIndices <- function(nClass, K, M, order, vv, perm) {
    .Call(`_ohoegdm_permuteAtableIndices`, nClass, K, M, order, vv, perm)
}

compute_srmr <- function(obs_mean, obs_cov, est_mean, est_cov) {
    .Call(`_ohoegdm_compute_srmr`, obs_mean, obs_cov, est_mean, est_cov)
}

ohoegdm_cpp <- function(Y, K, M, order, l0, l1, m0, bq, sdMH, burnin, chain_length = 10000L) {
    .Call(`_ohoegdm_ohoegdm_cpp`, Y, K, M, order, l0, l1, m0, bq, sdMH, burnin, chain_length)
}

