% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{insert_message}
\alias{insert_message}
\title{Insert message into a list at a specified position}
\usage{
insert_message(content, role = "user", x = NULL, position = -1, ...)
}
\arguments{
\item{content}{The content of the message.}

\item{role}{The role of the message. Can be "user", "system", "assistant". Default is "user".}

\item{x}{A list of messages. Default is NULL.}

\item{position}{The position at which to insert the new message. Default is -1 (end of list).}

\item{...}{Additional arguments such as images.}
}
\value{
A list of messages with the new message inserted at the specified position.
}
\description{
Inserts a message at a specified position in a list of messages.
The role and content are converted to a list and inserted into the input list at the given position.
}
\examples{
messages <- list(
    list(role = "system", content = "Be friendly"),
    list(role = "user", content = "How are you?")
)
insert_message("INSERT MESSAGE AT THE END", "user", messages)
insert_message("INSERT MESSAGE AT THE BEGINNING", "user", messages, 2)
}
