% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_aic}
\alias{ols_aic}
\title{AIC}
\usage{
ols_aic(model, method = c("R", "STATA", "SAS"))
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{method}{a character vector; specify the method to compute AIC. Valid
options include R, STATA and SAS}
}
\value{
Akaike Information Criterion
}
\description{
Akaike Information Criterion
}
\details{
AIC provides a means for model selection. Given a collection of models for the data, AIC estimates the 
quality of each model, relative to each of the other models. R and STATA use loglikelihood to compute AIC. SAS
uses residual sum of squares. Below is the formula in each case:

\emph{R & STATA}
\deqn{AIC = -2(loglikelihood) + 2p}

\emph{SAS}
\deqn{AIC = n * ln(SSE / n) + 2p}

where \emph{n} is the sample size and \emph{p} is the number of model parameters including intercept.
}
\examples{
# using R computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model)

# using STATA computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model, method = 'STATA')

# using SAS computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_aic(model, method = 'SAS')
}
\references{
Akaike, H. (1969). “Fitting Autoregressive Models for Prediction.” Annals of the Institute of Statistical
Mathematics 21:243–247.

Judge, G. G., Griffiths, W. E., Hill, R. C., and Lee, T.-C. (1980). The Theory and Practice of Econometrics.
New York: John Wiley & Sons.
}

