% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_input.R
\name{read_input}
\alias{read_input}
\title{Read input file}
\usage{
read_input(
  infile,
  include_formats = NULL,
  exclude_formats = NULL,
  formats_def = NULL,
  infile_data_output = FALSE
)
}
\arguments{
\item{infile}{Input CSV file name}

\item{include_formats}{Which formats to include in checking}

\item{exclude_formats}{Which formats to exclude from checking}

\item{formats_def}{New formats definition}

\item{infile_data_output}{Include infile data frame in the result}
}
\value{
A list of output variables
\itemize{
  \item \code{format} - Detected input format name
  \item \code{format_def} - Detected format definition
  \item \code{patient_id} - Extracted patient_id
  \item \code{device_id} - Extracted device_id
  \item \code{data} - Extracted timestamps 
  \item \code{log} - Log of the format detection
  \item \code{infile_data} - Raw input data
}
}
\description{
Read input file
}
\examples{
  input_file <- system.file('extdata', 'sample-data-ecap2.csv', package = 'oncmap')
  input <- read_input("tests/testthat/ecap1.csv")
}
