% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_postcode_samples}
\alias{sim_postcode_samples}
\title{Simulate a high-cardinality feature and a binary response}
\usage{
sim_postcode_samples(
  df_levels,
  n = 2000L,
  threshold = 1000,
  prob = c(0.3, 0.1),
  seed = 1001
)
}
\arguments{
\item{df_levels}{number of levels}

\item{n}{number of samples}

\item{threshold}{the threshold for determining if a postal code is rare}

\item{prob}{occurrence probability vector of the class 1 event in rare and non-rare postal codes}

\item{seed}{random seed}
}
\value{
a data frame of samples with postal codes, response labels, and level rarity status
}
\description{
Simulate a high-cardinality feature and a binary response
}
\note{
The code is derived from the example described in the "rare levels"
vignette in the \code{vtreat} package.
}
\examples{
df_levels <- sim_postcode_levels(nlevels = 500, seed = 42)
df_postcode <- sim_postcode_samples(
  df_levels,
  n = 10000, threshold = 3000, prob = c(0.2, 0.1), seed = 43
)
head(df_postcode)
}
