% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping_batches.R
\name{map_overlapping_batches}
\alias{map_overlapping_batches}
\title{Mapping overlapping batches}
\usage{
map_overlapping_batches(
  input.seq,
  size = 50,
  overlap = 15,
  phase_cores = 1,
  verbose = FALSE,
  seeds = NULL,
  tol = 1e-04,
  rm_unlinked = TRUE,
  max.gap = FALSE,
  parallelization.type = "PSOCK"
)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{phase_cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{verbose}{A logical, if TRUE its output progress status
information.}

\item{seeds}{A vector of phase information used as seeds for the first
batch}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{rm_unlinked}{When some pair of markers do not follow the linkage criteria, 
if \code{TRUE} one of the markers is removed and map is performed again.}

\item{max.gap}{the marker will be removed if it have gaps higher than this defined threshold in both sides}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{outcross} with the raw
data.} \item{twopt}{name of the object of class \code{rf.2pts} with the
2-point analyses.}
}
\description{
Apply the batch mapping algorithm using overlapping windows.
}
\details{
This algorithm implements the overlapping batch maps for high density
marker sets. The mapping problem is reduced to a number of subsets (batches)
which carry information forward in order to more accurately estimate
recombination fractions and phasing. It is a adapted version of
map.overlapping.batches function of BatchMap package. The main differences are
that this onemap version do not have the option to reorder the markers 
according to ripple algorithm and, if the it finds markers that do not reach the linkage
criterias, the algorithm remove the problematic marker and repeat the analysis.
Than, the output map can have few markers compared with the input.seq.
}
\seealso{
\code{\link[onemap]{pick_batch_sizes}}, \code{\link[onemap]{map}}
}
\keyword{utilities}
