% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_raw_data.R
\name{plot.onemap}
\alias{plot.onemap}
\title{Draw a graphic of raw data for any OneMap population}
\usage{
\method{plot}{onemap}(x, all = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{onemap}, with data and additional information}

\item{all}{a TRUE/FALSE option to indicate if results will be
plotted together (if TRUE) or splitted based on their
segregation pattern. Only used for outcross populations.}

\item{...}{currently ignored}
}
\value{
a ggplot graphic
}
\description{
Shows a heatmap (in ggplot2, a graphic of geom "tile") for raw data.
Lines correspond to markers and columns to individuals.
The function can plot a graph for all marker types, depending of the cross type (dominant/codominant markers, in all combinations).
The function receives a onemap object of class \code{onemap}, reads information
from genotypes from this object, converts it to a long dataframe format
using function melt() from package reshape2() or internal function create_dataframe_for_plot_outcross(), converts numbers from the object
to genetic notation (according to the cross type), then plots the graphic.
If there is more than 20 markers, removes y labels
For outcross populations, it can show all markers together, or it can split them according the segregation
pattern.
}
\examples{

\donttest{
# library(ggplot2)
data(onemap_example_bc) # Loads a fake backcross dataset installed with onemap
plot(onemap_example_bc) # This will show you the graph

# You can store the graphic in an object, then save it with a number of properties
# For details, see the help of ggplot2's function ggsave()
g <- plot(onemap_example_bc)

data(onemap_example_f2) # Loads a fake backcross dataset installed with onemap
plot(onemap_example_f2) # This will show you the graph

# You can store the graphic in an object, then save it with a number of properties
# For details, see the help of ggplot2's function ggsave()
g <- plot(onemap_example_f2)

data(onemap_example_out) # Loads a fake full-sib dataset installed with onemap
plot(onemap_example_out) # This will show you the graph for all markers
plot(onemap_example_out, all=FALSE) # This will show you the graph splitted for marker types

# You can store the graphic in an object, then save it.
# For details, see the help of ggplot2's function ggsave()
g <- plot(onemap_example_out, all=FALSE)
}

}
