% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{onetime_been_done}
\alias{onetime_been_done}
\title{Check if a onetime call has already been made}
\usage{
onetime_been_done(
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL
)
}
\arguments{
\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}
}
\value{
\code{TRUE} if the call has been recorded (within the
\code{expiry} time, if given).
}
\description{
Check if a onetime call has already been made
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1)

onetime_been_done(id = id)
onetime_message("Creating an ID",  id = id)
onetime_been_done(id = id)

onetime_reset(id = id)
options(oo)
}
