% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_input.R
\name{make_input}
\alias{make_input}
\title{Make a forecast matrix (as data.frame) from observations.}
\usage{
make_input(observations, kseq)
}
\arguments{
\item{observations}{vector of observations.}

\item{kseq}{vector of integers, respresenting the desired "k-steps ahead".}
}
\value{
Returns a forecast matrix (as a data.frame) with simply the observation vector copied to each column.
}
\description{
This function creates a data.frame with columns for each horizon such that it can be 
added to a data.list and used in a forecast model.
}
\examples{

# Data for example
D <- subset(Dbuilding, c("2010-12-15","2010-12-20"))

# Generate the input
make_input(D$heatload, 1:4)

# Set is in D, such that it can be used in input expressions (e.g. by model$add_inputs(AR = "Ar0")
D$AR0 <- make_input(D$heatload, 1:36)

}
