% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-code-lists.R
\name{ons_codelists}
\alias{ons_codelists}
\alias{ons_codelist}
\alias{ons_codelist_editions}
\alias{ons_codelist_edition}
\title{Explore codes and lists}
\usage{
ons_codelists()

ons_codelist(code_id = NULL)

ons_codelist_editions(code_id = NULL)

ons_codelist_edition(code_id = NULL, edition = NULL)
}
\arguments{
\item{code_id}{\verb{[character]}. The id of a codelist.}

\item{edition}{\verb{[character]}     A subset of the dataset representing a specific time period.
For some datasets this edition can contain all time periods (all historical data).
The latest version of this is displayed by default.}
}
\value{
A list or character vector.
}
\description{
Used to get details about codes and code lists stored by ONS. Codes are used
to provide a common definition when presenting statistics with related categories.
Codes are gathered in code lists, which may change over time to include new or
different codes. The meaning of a code should not change over time, but new codes
may be created where new meaning is required.
}
\examples{
\donttest{
ons_codelists()
ons_codelist(code_id = "quarter")

#editions
ons_codelist_editions(code_id = "quarter")
ons_codelist_edition(code_id = "quarter", edition = "one-off")
}

}
